# WhatsApp Business API Setup Guide

## Overview
To enable automatic WhatsApp message sending (instead of just generating links), you need to set up WhatsApp Business API.

## Current WhatsApp Methods

### 1. Web Links (Default - No API Required)
- **How it works**: Generates WhatsApp links that open WhatsApp with pre-filled messages
- **Pros**: No setup required, works immediately
- **Cons**: Requires manual clicking to send messages
- **Status**: ✅ Currently implemented

### 2. WhatsApp Business API (Automatic Sending)
- **How it works**: Automatically sends messages via WhatsApp's official API
- **Pros**: Fully automatic, no user intervention required
- **Cons**: Requires setup and approval from Meta/Facebook
- **Status**: 🔧 Requires configuration

## Setting Up WhatsApp Business API

### Step 1: Create Meta Developer Account
1. Go to [Meta for Developers](https://developers.facebook.com/)
2. Create a new app or use existing app
3. Add WhatsApp Business API product to your app

### Step 2: Get API Credentials
1. In your Meta app, go to WhatsApp > Getting Started
2. Note down:
   - **Access Token** (API Key)
   - **Phone Number ID**
   - **Business Account ID**

### Step 3: Configure in POS System
1. Go to Settings > WhatsApp Settings
2. Change "WhatsApp Method" to "WhatsApp Business API"
3. Enter your credentials:
   - **API Key**: Your Meta Access Token
   - **API URL**: `https://graph.facebook.com/v18.0`
   - **Phone Number ID**: Your WhatsApp Phone Number ID

### Step 4: Test Configuration
1. Click "Test WhatsApp Configuration"
2. Verify that test messages are sent successfully

## Alternative: WhatsApp Business App Integration

If you don't want to set up the API, you can use the WhatsApp Business App method:

1. Install WhatsApp Business app on your phone/tablet
2. In POS Settings, select "WhatsApp Business App"
3. Enter your business phone number
4. The system will generate links that open your WhatsApp Business app

## Troubleshooting

### Web Links Not Opening
- Ensure WhatsApp is installed on the device
- Check if pop-up blockers are disabled
- Try using a different browser

### API Not Working
- Verify your API credentials are correct
- Check if your Meta app is approved for WhatsApp Business API
- Ensure your phone number is verified in Meta Business Manager
- Check API rate limits and quotas

### Messages Not Sending
- Verify customer phone numbers are in correct format (+country code)
- Check if customers have opted out of WhatsApp messages
- Ensure your business account is in good standing

## Recommended Setup

For most users, we recommend starting with **Web Links** method as it:
- Requires no setup
- Works immediately
- Is free to use
- Provides good user experience

For businesses with high volume or requiring full automation, consider setting up the **WhatsApp Business API**.

## Support

If you need help setting up WhatsApp Business API:
1. Check Meta's official documentation
2. Contact Meta Business Support
3. Consider using a WhatsApp Business Solution Provider 